/*****************************************************************************
 *
 * File:		ITC2File.h
 * Description:	Header file defining functions and the format of the iTunes
 *				.itc2 files used for album thumbnails
 * Author:		nada
 * Copyright:	nada-labs.net
 *				The author hereby grants the use and redistribution of this
 *				code for non-commercial works only.
 * Created:		2010-01-29
 *
 ****************************************************************************/

#ifndef _ITC2_H_
#define _ITC2_H_

//Need to swap the numbers around as we are building on a little endian machine
//Change to 0 if compiling on a big endian machine.
#if 1
#define SWAP_ENDIAN(x)		(((x & 0x000000FF) << 24) | ((x & 0x0000FF00) << 8) | ((x & 0x00FF0000) >> 8) | ((x & 0xFF000000) >> 24))
#else
#define SWAP_ENDIAN(x)		(x)
#endif

//Defines for the header values
#define ITC2_TYPE_HEADER		(0x69746368)
#define ITC2_HEADER_ARTWORK		(0x61727477)

//Structure of the ITC2 Header
typedef struct _itc2_header {
unsigned int SectionLength;				//Size of the header
unsigned int SectionType;				//ITC2_HEADER_MAGIC
unsigned int Unknown[4];				//2, 2, 2, 0 respectivly
unsigned int Contents;					//ITC2_HEADER_ARTWORK
} ITC2Header;

#define ITC2_TYPE_ITEM	(0x6974656D)	//'item'	Item secion

typedef struct _itc2_item {
	unsigned int	SectionLength;		//Size of the entire section
	unsigned int	SectionType;		//ITC2_TYPE_ITEM
	unsigned int	HeaderLength;		//Offset to data from start of item, usaully 0xD0
	unsigned int	Unknowns_1[4];		//1, 2, 1, 0 respectivly?
	unsigned char	LibraryId[8];		//ID of the library
	unsigned char	TrackId[8];			//Track ID
	unsigned int	ItemLocation;		//location of the item, see ITC2_ITEM_LOCATION_XXX
	unsigned int	ItemFormat;			//format of the item, see ITC2_ITEM_FORMAT_XXX
	unsigned int	Unknowns_2;			//0
	unsigned int	Width;				//The width of the image in pixels
	unsigned int	Height;				//The heigh of the image in pixels
	unsigned int 	Unknowns_3[3];		//0, 0, 0
	unsigned int	DisplayWidth;		//The amount of width the image takes on screen
	unsigned int	DisplayHeight;		//The amount of height the image takes on screen
	unsigned int	Unknowns_4[30];		//0...
	unsigned int	Data;				//'data'
} ITC2Item;


//The types of item locations that we know about
#define ITC2_ITEM_LOCATION_LOCAL	(0x6C6F636C)	//'locl'	Local image file?

//The types of image formats that we know about
#define ITC2_ITEM_FORMAT_PNG		(0x504E4766)	//'PNGf'	PNG file format


#endif